<?php 
    /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * l/inee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "include/costanti.php";
    include "include/util.php";
    include "gUtil/DbManager.php";
    include "gUtil/GeneratoreForm.php";
    include "gUtil/Ricerca.php";
    include "gUtil/ControlloreStringhe.php";
    include "classi/GeneratoreUrl.php";
    include "classi/GestoreJavascript.php";
    include "template/include/includeClassiTemplate.php";
    include "template/stile.php";
    
    //i dati del database sono definiti nel file costanti.php
    $geecomDb          = new DbManager($costantiDatabase);		
    $gestoreJavascript = new GestoreJavascript();
    
    $impostazioni          = recuperaImpostazioni($geecomDb);
    $impostazioniLingue    = $geecomDb->leggiSingolaRiga("geecAd_impostazioniLingue", 1);
    $configurazioneAspetto = $geecomDb->leggiSingolaRiga("geec_configurazioniAspetto", "si","selezionataAdmin");
    $inclusioni            = $geecomDb->leggiSingolaRiga("geecAd_inclusioni", 1);
    $profiliSocial         = $geecomDb->leggiSingolaRiga("geec_profiliSocial", 1);
    session_start();
    
    if(isset($_SESSION["geecomUser_id"])) {
        $utente = $geecomDb->leggiSingolaRiga("geec_utenti", $_SESSION["geecomUser_id"]);
    }
        
    if(isset($_GET["alias"]) && $_GET["alias"]!="") { //se il campo passato in input è un alias non vuoto
        $alias = filter_input(INPUT_GET, "alias",FILTER_SANITIZE_STRING);

        //prende i dati dell'articolo
        $pagina = $geecomDb->leggiSingolaRiga("geecAd_contenuti", $alias,"alias");
    }
    else { // altrimenti mosta la pagina login
        
        $pagina = $geecomDb->leggiSingolaRiga("geecAd_contenuti", $impostazioni["paginaLogin"]);
    }
    
    if(isset($_SESSION["geecomUser_email"]) && $impostazioni["paginaLogin"]==$pagina["id"]) {
        $pagina     = $geecomDb->leggiSingolaRiga("geecAd_contenuti", $impostazioni["homePage"]);
        $linkPagina = GeneratoreUrl::creaUrlContenuto($pagina, $impostazioni["ottimizzazioneUrl"], $impostazioni["urlPiattaforma"]);
        header("Location: $linkPagina");
        exit();
    }
    else if(!isset($_SESSION["geecomUser_email"]) && ($impostazioni["paginaLogin"]==$pagina["id"] || $impostazioni["paginaLoginEn"]==$pagina["id"] || $impostazioni["paginaRecuperoPassword"]==$pagina["id"])) { // sta accedendo alla pagina login o recupera password
        $_SESSION["tokenSicurezza"] = sha1(rand(0,100000));
    }
    else if(!isset($_SESSION["geecomUser_email"]) && $pagina["privato"]=="no") { // sta accedendo ad una pagina non privata
       
    }
    else if(!isset($_SESSION["geecomUser_email"]) && $impostazioni["paginaLogin"]!=$pagina["id"]) { // redirect alla pagina home
        $pagina     = $geecomDb->leggiSingolaRiga("geecAd_contenuti", $impostazioni["paginaLogin"]);
        $linkPagina = GeneratoreUrl::creaUrlContenuto($pagina, $impostazioni["ottimizzazioneUrl"], $impostazioni["urlPiattaforma"]);
        header("Location: $linkPagina");
        exit();
    }
    
    $lingua = $pagina["linguaContenuto"];
    
    $datiCookie = $geecomDb->leggiSingolaRiga("geecAd_leggeCookie", $lingua,"lingua");
    
    //incrementa il numero di visite, controlla è l'amministratore a visualizzare l'articolo, in questo caso
    //non lo incrementa
    if(!isset($_SESSION["geecomAdmin_email"])) {
        $dataVisualizzazione = date("Y-m-d");
        $queryAggiornamentoVisite = "UPDATE geecAd_contenuti SET numeroVisite=numeroVisite+1, dataUltimaVisita='$dataVisualizzazione' WHERE id={$pagina["id"]}";
        $geecomDb->eseguiQueryScrittura($queryAggiornamentoVisite);
    }
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
    <head>
        <?php 
            echo $inclusioni["inizioHead"]; 
        ?>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
        <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
        <meta name="generator" content="Geecom Admin"/>
        <meta name="description" content="<?php echo((isset($_GET["alias"])) ? $pagina["metaDescrizione"] : $impostazioni["descrizioneSito"]); ?>" />
        
        <title><?php echo $impostazioni["nomePiattaforma"]; ?></title>

        <!-- Favicon-->
        <link rel="icon" href="favicon.ico" type="image/x-icon">

        <?php
            include "include/includeCssBase.php";
            
            echo "<style type=\"text/css\">
                    {$pagina["cssGenerato"]}
                    {$pagina["cssAggiuntivo"]}
                </style>";
            
            echo $inclusioni["fineHead"];
        ?>
    </head>

    <?php
        include "template/include/templatePagina/{$pagina["template"]}";
    ?>
</html>
